<?php /**
* Alpaca API Proxy for Paper Trading Simulator
* Place this file on your server and update the config.php with your API keys */
// Include configuration require_once 'config.php';
// Enable CORS for frontend requests header("Access-Control-Allow-Origin: *"); header("Access-Control-Allow-Methods: POST, GET, OPTIONS"); header("Access-Control-Allow-Headers: Content-Type");
// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
exit(0); }
// Token verification
if (API_TOKEN !== 'YOUR_SECURE_TOKEN') {
if (empty($_POST['token']) || $_POST['token'] !== API_TOKEN) { http_response_code(401);
echo json_encode(['error' => 'Invalid token']);
exit;
} }
// Get request data

$endpoint = $_POST['endpoint'] ?? '';
$method = $_POST['method'] ?? 'GET';
$body = isset($_POST['body']) ? json_decode($_POST['body'], true) : null;
// Validate endpoint $allowedEndpoints = [
'/v2/account', '/v2/orders', '/v2/positions', '/v2/assets', '/v2/clock', '/v2/activities'
];
$validEndpoint = false;
foreach ($allowedEndpoints as $allowed) {
if (strpos($endpoint, $allowed) === 0) { $validEndpoint = true;
break;
} }
if (!$validEndpoint) {
http_response_code(403);
echo json_encode(['error' => 'Endpoint not allowed']); exit;
}

// Make request to Alpaca API
$url = ALPACA_BASE_URL . $endpoint;
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method); curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_HTTPHEADER, [
'APCA-API-KEY-ID: ' . ALPACA_API_KEY, 'APCA-API-SECRET-KEY: ' . ALPACA_API_SECRET, 'Content-Type: application/json'
]);
if ($body && in_array($method, ['POST', 'PUT', 'PATCH'])) {
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body)); }
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); if (curl_error($ch)) {
http_response_code(500);
echo json_encode(['error' => curl_error($ch)]); }else{
http_response_code($httpCode); header('Content-Type: application/json'); echo $response;
}
curl_close($ch); exit;
